#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//IFOSbMod01.fsh   by Dave Hoskins   
//https://www.shadertoy.com/view/4ddyR8
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// https://www.shadertoy.com/view/4ddyR8
// By David Hoskins.
// buffer b
bool clipTime(float t)
{
   return (t >5.0 && t < 11. || t > 20. && t < 24.);
}
// Add noise to the triangles to make it a little clearer...
#define ADD_DITHER

#define HASHSCALE1 .1031
#define HASHSCALE3 vec3(.1031, .1030, .0973)
#define randValues vec2(0.01, 0.005)

vec4 col = vec4(0.0);
vec2 uv;
const vec4 INV_SCALE  = vec4(.96, 1.1, .96,1.1)/256.0;
vec2 fcoord;

//========================================================================
float hash11(float p)
{
	vec3 p3  = fract(vec3(p) * HASHSCALE1);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z);
}


vec2 hash21(float p)
{
	vec3 p3 = fract(vec3(p) * HASHSCALE3);
	p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.xx+p3.yz)*p3.zy);

}

vec2 hash22(vec2 p)
{
	vec3 p3 = fract(vec3(p.xyx) * HASHSCALE3);
    p3 += dot(p3, p3.yzx+19.19);
    return fract((p3.xx+p3.yz)*p3.zy);

}
vec2 noise(float p)
{
	float f = fract(p);
    p = floor(p);
	f = f*f*(3.0-2.0*f);
    return mix(hash21(p), hash21(p+1.0), f)-.5;
}

float noise1(float p)
{
	float f = fract(p);
    p = floor(p);
	f = f*f*(3.0-2.0*f);
    return mix(hash11(p), hash11(p+1.0), f)-.5;
}

  


//========================================================================
vec4 unpackCoord(uint u) 
{
    return vec4(u & 255U, (u>>8U)&255U, (u>>16U)&255U, (u>>24U) & 255U) * INV_SCALE;
}

//========================================================================
vec4 unpackColour(uint u) 
{
   return vec4(u & 255U, (u>>8U)&255U, (u>>16U)&255U, (u>>24U) & 255U) / 255.;
}

//========================================================================
void Tri(uint pA, uint pB, uint pCol)
{
	vec2 pos = uv;
	vec4 u1 = unpackCoord(pA);
    vec4 u2 = unpackCoord(pB);
	vec2 a = u1.xy;
    vec2 b = u1.zw;
    vec2 c = u2.xy;

#ifdef ADD_DITHER
	pos += hash22(fcoord) * randValues.x - randValues.y;
#endif

	// Triangle test...
	vec2 as = pos-a;
	vec2 bs = pos-b;
	if  ( (b.x-a.x)*as.y-(b.y-a.y)*as.x > 0.0 &&
		  (a.x-c.x)*as.y-(a.y-c.y)*as.x > 0.0 &&
    	  (c.x-b.x)*bs.y-(c.y-b.y)*bs.x > 0.0)
	{
		vec4 c1 = unpackColour(pCol);
		
			col.xyz = mix (col.xyz, c1.xyz, c1.w);
	}
}
mat2 rot2D(float a)
{
    return mat2(sin(a), cos(a), -cos(a), sin(a));
}
//========================================================================
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    
    if (!clipTime(iTime)) discard;
    // I know, right?.... :)
    fcoord = fragCoord;
	uv = fragCoord.xy / iResolution.y*2.;
    //uv +=vec2(-0.15, .07);
      uv +=vec2(-0.55, .21);
	

	
    float sh = iTime+8.;
    sh *= (sh+7.);
    
    uv+= noise(sh)*vec2(.05, .02);
    
    float r = noise1(sh*.2+9.);
    vec2 cen = vec2(.6, -3.);
    uv = rot2D(r*.03+3.12/2.) * (uv-cen)+cen;
    uv.x *=.7 ;
	
	Tri(2429117142U, 5928U,847539000U);
	Tri(795023407U, 8498U,992585213U);
	Tri(1640879957U, 61599U,959929590U);
	Tri(1794081574U, 56285U,978681085U);
	Tri(2308205710U, 31272U,990922744U);
	Tri(471606045U, 29035U,967370237U);
	Tri(4230610792U, 28143U,508957420U);
	Tri(900125877U, 44243U,1002240508U);
	Tri(3837804473U, 26518U,939124989U);
	Tri(3384053884U, 54957U,1006501121U);
	Tri(690107177U, 5945U,963489789U);
	Tri(4285071235U, 60536U,998793679U);
	Tri(878584137U, 13913U,1004926454U);
	Tri(2653207589U, 26296U,716606901U);
	Tri(1028264750U, 25929U,1002295293U);
	Tri(1253486472U, 41666U,1001258750U);
	Tri(3949713882U, 20345U,604585208U);
	Tri(1787328624U, 35978U,1005297918U);
	Tri(3011422913U, 20919U,1004666366U);
	Tri(2329790504U, 54072U,736359152U);
	Tri(4225912063U, 63181U,842600460U);
	Tri(2430165157U, 44947U,989593341U);
	Tri(1287097750U, 50881U,989265662U);
	Tri(1160263695U, 28708U,973080062U);
	Tri(2074432441U, 26514U,797180667U);
	Tri(2700330123U, 59887U,545523225U);
	Tri(4199131589U, 21177U,999030013U);
	Tri(1233536406U, 15758U,913195499U);
	Tri(4283039669U, 19155U,989782269U);
	Tri(3533325627U, 24633U,991291134U);
	Tri(3278150346U, 25268U,989593341U);
	Tri(1842903272U, 15065U,997131781U);
	Tri(773054267U, 37032U,520618616U);
	Tri(2636558119U, 42799U,1006553337U);
	Tri(599667643U, 8652U,984807973U);
	Tri(1697878837U, 49511U,989789678U);
	Tri(2133512360U, 25164U,998212093U);
	Tri(3921267926U, 52158U,995935485U);
	Tri(1131699863U, 13959U,602664972U);
	Tri(575616848U, 13915U,1006566910U);
	Tri(2660480709U, 20918U,1006435837U);
	Tri(3513702304U, 22663U,997626110U);
	Tri(416332474U, 40950U,908591711U);
	Tri(3520506099U, 38103U,859847519U);
	Tri(2182876652U, 3207U,976027650U);
	Tri(3837910738U, 32468U,977097982U);
	Tri(4280745781U, 37946U,946490608U);
	Tri(3359554925U, 42355U,950092545U);
	Tri(1586717317U, 30895U,965829366U);
	Tri(3771909336U, 52163U,990552829U);
	Tri(1466452814U, 34405U,951766769U);
	Tri(3210750263U, 37671U,822013481U);
	Tri(3500408728U, 65458U,954434426U);
	Tri(4242042863U, 30250U,633453054U);
	Tri(2457497749U, 28786U,984265726U);
	Tri(739921681U, 26665U,990446077U);
	Tri(1893884636U, 28313U,615575542U);
	Tri(2840306286U, 16188U,990444797U);
	Tri(1245666104U, 49542U,1004338686U);
	Tri(1606171564U, 57222U,990179325U);
	Tri(505165356U, 10539U,1006566909U);
	Tri(709318968U, 30795U,996144637U);
	Tri(2110503616U, 35291U,1001217278U);
	Tri(2771240523U, 43076U,998308093U);
	Tri(1477535533U, 10520U,989987070U);
	Tri(4283018888U, 64063U,978146399U);
	Tri(1253196202U, 26272U,1005184509U);
	Tri(740050959U, 27942U,990315006U);
	Tri(743058479U, 14154U,988450094U);
	Tri(4270508492U, 35273U,989921282U);
	Tri(1662268449U, 12309U,989856510U);
	Tri(1512845585U, 27936U,989855998U);
	Tri(1213688973U, 4949U,990326784U);
	Tri(1901508063U, 30191U,532675836U);
	Tri(2861493601U, 60785U,820112602U);
	Tri(649821880U, 7114U,639982851U);
	Tri(3274494768U, 56278U,942756281U);
	Tri(1111418981U, 57752U,957378558U);
	Tri(4291259697U, 65411U,819707642U);
	Tri(514218927U, 9913U,995633155U);
	Tri(934592199U, 58843U,738472306U);
	Tri(2861001389U, 30591U,860756477U);
	Tri(4289527761U, 55741U,995562563U);
	Tri(1881166124U, 15374U,989921790U);
	Tri(341020510U, 8413U,562189569U);
	Tri(2686681696U, 21572U,989462270U);
	Tri(4118828432U, 22648U,970180861U);
	Tri(3010347585U, 24378U,989920766U);
	Tri(2532214255U, 30400U,996439024U);
	Tri(479405699U, 11413U,1005452837U);
	Tri(691607349U, 7214U,1003288830U);
	Tri(985688502U, 28665U,991559680U);
	Tri(2791590998U, 38729U,987561725U);
	Tri(4268269505U, 22709U,972946941U);
	Tri(936984143U, 63445U,519827196U);
	Tri(3802847668U, 53656U,1006236157U);
	Tri(1775770569U, 28619U,993527038U);
	Tri(927187390U, 37050U,587071229U);
	Tri(1763403050U, 16676U,990643966U);
	Tri(1899271224U, 31844U,1006501373U);
	Tri(2103338574U, 50244U,1006567165U);
	Tri(2762206076U, 61604U,973100449U);
	Tri(1286004900U, 35779U,956235261U);
	Tri(2019125121U, 12375U,993078819U);
	Tri(63639035U, 1271U,705167517U);
	Tri(442121046U, 6509U,912547349U);
	Tri(3634162601U, 57800U,992215046U);
	Tri(3953542911U, 55447U,806817793U);
	Tri(1356080582U, 28369U,995164926U);
	Tri(1966120529U, 25457U,1006501373U);
	Tri(4082218344U, 16896U,989987073U);
	Tri(2637461035U, 39460U,873335753U);
	Tri(1482357943U, 64988U,739970826U);
	Tri(527969654U, 12450U,963528192U);
	Tri(3040651054U, 57651U,943166389U);
	Tri(825715347U, 14995U,980114946U);
	Tri(1814995017U, 44924U,989789950U);
	Tri(3242425952U, 19773U,987758077U);
	Tri(441668663U, 45926U,792723198U);
	Tri(3529034554U, 54855U,1001637113U);
	Tri(1054946246U, 27344U,991691517U);
	Tri(740117774U, 28203U,989922045U);
	Tri(3296310845U, 52559U,698046535U);
	Tri(2520425836U, 28469U,1006501374U);
	Tri(1759213243U, 57817U,928871927U);
	Tri(4272287154U, 52605U,751551935U);
	Tri(558785107U, 13918U,897360891U);
	Tri(3479958937U, 13776U,518389502U);
	Tri(1790405778U, 27112U,995533607U);
	Tri(1221406931U, 14021U,997524222U);
	Tri(47679888U, 4581U,990773504U);
	Tri(2864053100U, 64121U,534700797U);
	Tri(1537368734U, 25003U,1006501623U);
	Tri(1733462887U, 13688U,995512066U);
	Tri(3536768470U, 52417U,1006436094U);
	Tri(2983437015U, 43721U,1005256446U);
	Tri(3077287264U, 50773U,983480497U);
	Tri(1701531994U, 27758U,970708979U);
	Tri(1750115454U, 11374U,991760641U);
	Tri(1731957248U, 31774U,982626326U);
	Tri(625367608U, 33616U,990051837U);
	Tri(2774848043U, 51802U,620554621U);
	Tri(509232694U, 25178U,661013245U);
	Tri(3361315676U, 39764U,993396481U);
	Tri(402977U, 50066U,989922625U);
	Tri(3425295965U, 44584U,541750268U);
	Tri(3148070803U, 54450U,1006566877U);
	Tri(3079192484U, 43424U,985175810U);
	Tri(562392526U, 17868U,991560194U);
	Tri(2348356498U, 6001U,757927680U);
	Tri(4035504298U, 15762U,788529530U);
	Tri(2571445236U, 7423U,995035646U);
	Tri(2381477342U, 41150U,629576189U);
	Tri(1835810713U, 14462U,814649618U);
	Tri(309864741U, 10167U,993212929U);
	Tri(1127839834U, 33898U,822084093U);
	Tri(3149513898U, 54447U,687067435U);
	Tri(2778632102U, 35734U,992740347U);
	Tri(1716601440U, 10061U,944134527U);
	Tri(2307318311U, 61232U,574175746U);
	Tri(3948974830U, 33261U,860973821U);
	Tri(4208114729U, 64839U,915369379U);
	Tri(1245630765U, 41320U,889061117U);
	Tri(3766020154U, 64617U,1003134649U);
	Tri(3381507496U, 23705U,587794942U);
	Tri(78398118U, 19918U,974062082U);
	Tri(3785021371U, 50334U,839124067U);
	Tri(3276063426U, 40774U,600681217U);
	Tri(4225207027U, 65472U,993600577U);
	Tri(3015104161U, 55488U,975053313U);
	Tri(4241990760U, 64655U,547793902U);
	Tri(3755737028U, 65495U,877605571U);
	Tri(546269547U, 52026U,973146116U);
	Tri(975077188U, 31567U,991560192U);
	Tri(2485713703U, 44853U,760768714U);
	Tri(1975531456U, 4515U,678253829U);
	Tri(3626044745U, 12586U,990445570U);
	Tri(2422255223U, 2906U,993736456U);
	Tri(1438158119U, 46038U,553582333U);
	Tri(864374670U, 23498U,515718212U);
	Tri(2522574921U, 19494U,989987082U);
	Tri(1145843523U, 26676U,996644094U);
	Tri(3259608157U, 30252U,1001938177U);
	Tri(4147836376U, 54115U,765760422U);
	Tri(1618436462U, 39507U,977682607U);
	Tri(3124480422U, 48041U,535022284U);
	Tri(4002015527U, 62782U,778781780U);
	Tri(4292619583U, 65333U,685296126U);
	Tri(2320409210U, 32666U,995244637U);
	Tri(1787646651U, 21115U,251287806U);
	Tri(897018266U, 14259U,995703300U);
	Tri(2497576945U, 8925U,990576641U);
	Tri(2296684013U, 27115U,986185213U);
	Tri(1061061941U, 43369U,754908926U);
	Tri(3441666136U, 9795U,738065918U);
	Tri(3284511925U, 54193U,687797884U);
	Tri(1138626815U, 6058U,991297538U);
	Tri(3515073881U, 64041U,607670653U);
	Tri(3477645811U, 43403U,167837943U);
	Tri(1370910647U, 19904U,892483529U);
	Tri(2686698542U, 38964U,832151671U);
	Tri(1855348655U, 13441U,998263081U);
	Tri(816317656U, 900U,559809282U);
	Tri(2586424615U, 45483U,945641610U);
	Tri(8140319U, 21020U,989921538U);
	Tri(4249459233U, 53534U,893921295U);
	Tri(4069035934U, 61530U,1000714224U);
	Tri(4187999629U, 60988U,748130483U);
	Tri(71256106U, 896U,991822336U);
	Tri(2912067520U, 26551U,1006567165U);
	Tri(3005665353U, 46401U,889655375U);
	Tri(1287024521U, 28328U,957546754U);
	Tri(4206624729U, 48868U,991236899U);
	Tri(926299735U, 3640U,990648065U);
	Tri(59061287U, 12451U,842994177U);
	Tri(4289128645U, 59259U,535080117U);
	Tri(1532909000U, 9921U,995965184U);
	Tri(2112906216U, 39912U,999073534U);
	Tri(1719228792U, 26732U,901482424U);
	Tri(676285018U, 11868U,561425914U);
	Tri(1219394127U, 28364U,184879095U);
	Tri(3008280394U, 50002U,1006567089U);
	Tri(2925577310U, 48038U,184877595U);
	Tri(2187339215U, 4751U,993798144U);
	Tri(1118981028U, 47756U,931490477U);
	Tri(2216675665U, 45397U,521672448U);
	Tri(1636074586U, 30339U,641159898U);
	Tri(3389668765U, 52231U,521805601U);
	Tri(2260775102U, 39394U,980572244U);
	Tri(2237629148U, 33487U,989724414U);
	Tri(3668049877U, 53476U,892613188U);
	Tri(4283808291U, 65317U,991035685U);
	Tri(3503606730U, 53957U,1006501629U);
	Tri(3060425279U, 20775U,908794137U);
	Tri(639777359U, 2843U,989987330U);
	Tri(1277814052U, 2630U,976695296U);
	Tri(3173112425U, 32296U,925443647U);
	Tri(768219449U, 11325U,527390978U);
	Tri(459020323U, 6173U,687998424U);
	Tri(982715772U, 53321U,504693263U);
	Tri(4096261986U, 48934U,895769701U);
	Tri(1548336548U, 19017U,572719391U);
	Tri(2096424137U, 65492U,976362826U);
	Tri(3651652549U, 26929U,524750866U);
	Tri(2490095456U, 37271U,979136932U);
	Tri(2933895358U, 55772U,977487235U);
	Tri(3560037696U, 52536U,923996216U);
	Tri(1670658232U, 6063U,893859086U);
	Tri(2830555103U, 46306U,996826997U);
	Tri(3738227663U, 55969U,918400211U);
	Tri(3547056485U, 55117U,997751474U);
	Tri(3663062825U, 65382U,267974811U);
	Tri(2192225145U, 40355U,994535161U);
	Tri(3262158754U, 25947U,914127496U);
	Tri(440901154U, 43308U,994265424U);


    float n = (1.2+sin(iTime*.2-2.)*.4);
    n += sin(iTime*10.)*.2;
	fragColor = vec4(min(col.xyz* n, 1.0), 1.0 );
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

